#local resolution = 640;
#declare flashlight1_res640_lit_spl_pos_data = array[resolution]
#declare flashlight1_res640_lit_spl_v1_data = array[resolution]
#declare flashlight1_res640_lit_spl_v2_data = array[resolution]
#local pos_temp = <0,0,0>;
#local v1_temp = <0,0,0>;
#local v2_temp = <0,0,0>;
#local color_multi = 4800;
#local light_bulb_color = rgb <1, 1, 1>;
#local cylinder_color = rgb <0.005, 0.005, 0.005>;
#local cylinder_reflection = 0.73;
#local cylinder_r = 2.6;
#local cylinder_hght = 6;
#local light_bulb_r = 0.25;
#local light_bulb_z = 2.9;
#local hypothesis_emission_area = pi*pow(cylinder_r,2);


#fopen light_samples_info_file "flashlight1_res640_spl_info.txt" read
#for(i, 0, resolution-1)
    #read (light_samples_info_file, pos_temp)
    #declare flashlight1_res640_lit_spl_pos_data[i] = pos_temp;
    #read (light_samples_info_file, v1_temp)
    #declare flashlight1_res640_lit_spl_v1_data[i] = v1_temp;
    #read (light_samples_info_file, v2_temp)
    #declare flashlight1_res640_lit_spl_v2_data[i] = v2_temp;
#end
#fclose light_samples_info_file


//------------emission object------------
//You can modify this object yourself,
//but notice that the emission object entirly should be above the x-y plane.
//And it should not take any texture because the emission texture will be taken later.
#local emission_object =
union{
    sphere{
    <0, 0, light_bulb_z>, light_bulb_r
    }
    cylinder{
    <0,0,2.9>, <0,0,3.3>, light_bulb_r
    }
}


//------------look like object------------
//You can modify this object yourself,
//but notice that this shape should be a downward shape and better fit a circle of radius cylinder_r at origin on the x-y plane.
//You can give it some custom texture but it should not contain any emission component at all.
#local para_a = 0.5105;
#local multi = 100;
#local lamp_look_like =
union{
    difference{
        cylinder{
        <0, 0, 0>, <0, 0, cylinder_hght>, cylinder_r
        }
        difference{
            polynomial{
            2,
            xyz(2,0,0):multi*para_a,
            xyz(0,2,0):multi*para_a,
            xyz(0,0,1):multi*1,
            sturm
            }
            cylinder{
            <0,0,0>, <0,0,-0.06>, sqrt(0.06/para_a)
            }
        translate <0,0,3.39>
        }
        cylinder{
        <0,0,2.9>, <0,0,3.5>, 0.25
        }
        texture{
            pigment{color cylinder_color}
            finish{ambient 0 diffuse 1 reflection cylinder_reflection}
        }
    }
    difference{
        cylinder{
        <0,0,0>, <0,0,0.5>, cylinder_r
        }
        cylinder{
        <0,0,0-0.001>, <0,0,0.5+0.001>, cylinder_r-0.075
        }
        texture{
            pigment{color cylinder_color}
            finish{ambient 0 diffuse 1 reflection cylinder_reflection}
        }
    }
    cylinder{
    <0,0,3.3>, <0,0,3.5>, 0.25
        texture{
            pigment{rgb<0.01,0.01,0.01>}
            finish{ambient 0 diffuse 1}
        }
    }
    cylinder{
    <0,0,0>, <0,0,0.1>, cylinder_r-0.075-0.001
        material{
            texture{
                pigment{rgbf <0.94, 1, 0.97, 1>}
                finish { ambient 0 diffuse 0 reflection { 0, 1 fresnel } conserve_energy}
            }
            interior {
                ior 1.51714
                fade_power 1001
                fade_distance 1
                fade_color rgb<0.83,1,0.91>
            }
        }
    }
}

//------------hypothesis area shader------------
//you should not modify this part
#local hypothesis_area_shader =
disc{
<0, 0, 0>, z, cylinder_r
    texture{
        pigment{rgb<0,0,0>}
        finish{ambient 0 diffuse 1}
    }
    interior_texture{
        pigment{rgbt<0,0,0,1>}
        finish{ambient 0 diffuse 1}
    }
no_image
no_reflection
}


//------------light sources------------
//you should not modify this part
#ifdef(flashlight1_res640_pretrace)
#else

#macro Factor_Color_Vs_Fade_Distance(_fade_distance)
(1/_fade_distance/_fade_distance/2)
#end
#if(resolution < 10)
    #local digit = 1;
#elseif(resolution < 100)
    #local digit = 2;
#elseif(resolution < 1000)
    #local digit = 3;
#elseif(resolution < 10000)
    #local digit = 4;
#else
    #local digit = 5;
#end
#local light_source_set =
union{
    #for(i, 0, resolution-1)
        #local map_file_name_base = "flashlight1_res640_pretrace"
        #local map_file_name_number = str(i+1, -digit, 0)
        #local map_file_name = concat(map_file_name_base, map_file_name_number)
        #local p_image =
        pigment{
            image_map {
            png map_file_name
            gamma 1.0
            map_type 1
            interpolate 2
            }
        rotate <90, 0, 0>
        scale <1,1,-1>
        }
        #local f_image = function{pigment{p_image}}
        #local f_map = function(x,y,z){f_image(x,y,z).gray}
        #local p_map =
        pigment{            function{f_map(x,y,z)}
            color_map{
            [0 rgbt<1,1,1,0>]
            [1 rgbt<1,1,1,1>]
            }
        }

        union{
            light_source{
            <0,0,0>
            color light_bulb_color*color_multi*(hypothesis_emission_area/resolution/pi)*Factor_Color_Vs_Fade_Distance(0.001)
            spotlight
            radius 90
            falloff 90
            tightness 1
            point_at -z
            fade_power 2
            fade_distance 0.001
            }
            sphere{
            <0,0,0>, 1
                texture{
                    pigment{p_map}
                    finish{ambient 0 diffuse 1}
                }
            scale 0.0011
            no_image
            no_reflection
            no_radiosity
            }
        translate flashlight1_res640_lit_spl_pos_data[i]
        }
        #undef f_image
        #undef f_map
    #end
}


#end //end if//------------declare objects------------
//---------------------------------------
#declare flashlight1_res640_look_like_for_pretrace =
union{
    object{
    lamp_look_like
    }
    object{
    emission_object
        texture{
            pigment{color light_bulb_color}
            finish{ambient 0 diffuse 0 emission 1}
        }
    }
}
#ifdef(flashlight1_res640_pretrace)
#else

#declare flashlight1_res640 =
union{
    object{
    light_source_set
    }
    object{
    hypothesis_area_shader
    }
    object{
    lamp_look_like
    }
    object{
    emission_object
        texture{
            pigment{color light_bulb_color*color_multi}
            finish{ambient 0 diffuse 0 emission 1}
        }
    //no_radiosity
    }
}
#end //end if